/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.client_bound;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.net.Packet;
import net.montoyo.wd.utilities.BlockSide;

public class S2CMessageCloseGui
extends Packet {
    private BlockPos blockPos;
    private BlockSide blockSide;

    public S2CMessageCloseGui(BlockPos bp) {
        this.blockPos = bp;
        this.blockSide = null;
    }

    public S2CMessageCloseGui(BlockPos bp, BlockSide side) {
        this.blockPos = bp;
        this.blockSide = side;
    }

    public S2CMessageCloseGui(FriendlyByteBuf buf) {
        super(buf);
        this.blockPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        byte b = buf.readByte();
        this.blockSide = b <= 0 ? null : BlockSide.values()[b - 1];
    }

    @Override
    public void m_5779_(FriendlyByteBuf buf) {
        buf.writeInt(this.blockPos.m_123341_());
        buf.writeInt(this.blockPos.m_123342_());
        buf.writeInt(this.blockPos.m_123343_());
        if (this.blockSide == null) {
            buf.writeByte(0);
        } else {
            buf.writeByte(this.blockSide.ordinal() + 1);
        }
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (this.checkClient(ctx)) {
            ctx.enqueueWork(() -> {
                if (this.blockSide == null) {
                    Arrays.stream(BlockSide.values()).forEach(s -> WebDisplays.PROXY.closeGui(this.blockPos, (BlockSide)((Object)((Object)s))));
                } else {
                    WebDisplays.PROXY.closeGui(this.blockPos, this.blockSide);
                }
            });
            ctx.setPacketHandled(true);
        }
    }
}

